package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotSame;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.util.Helper;

/**
 * 
 * @author Getaneh Kassahun
 */

public class RoleTypeConverterTest extends AbstractMockMvcTests {

	private RoleTypeConverter roleTypeConverter;

	@Before
	public void setUp() {

		roleTypeConverter = new RoleTypeConverter();
	}

	@Test
	public void convert() {
		assertEquals("Administrator", roleTypeConverter.convert(Helper.getNewRoleType()).getRoleDescription());
		assertNotSame("Resercher", roleTypeConverter.convert(Helper.getNewRoleType()).getRoleDescription());
	}

	@Test
	public void convert2() {
		assertEquals("Administrator", roleTypeConverter.convert(Helper.getRoleTypeDTO()).getRoleDescription());
		assertNotSame("Resercher", roleTypeConverter.convert(Helper.getRoleTypeDTO()).getRoleDescription());
	}

}
